﻿Partial Public Class PointDragger
    Inherits UserControl
    Public Shared ReadOnly PointProperty As DependencyProperty =
        DependencyProperty.Register("Point",
                                    GetType(Point),
                                    GetType(PointDragger),
                                    New PropertyMetadata(AddressOf OnPointChanged))


    Public Event PointChanged As RoutedPropertyChangedEventHandler(Of Point)


    Public Sub New()
        InitializeComponent()
    End Sub


    Public Property Point() As Point
        Set(ByVal value As Point)
            SetValue(PointProperty, value)
        End Set
        Get
            Return CType(GetValue(PointProperty), Point)
        End Get
    End Property


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        args.ManipulationContainer = TryCast(VisualTreeHelper.GetParent(Me), UIElement)
        args.Handled = True
        MyBase.OnManipulationStarted(args)
    End Sub


    Protected Overrides Sub OnManipulationDelta(ByVal args As ManipulationDeltaEventArgs)
        Dim translate = args.DeltaManipulation.Translation
        Me.Point = New Point(Me.Point.X + translate.X, Me.Point.Y + translate.Y)
        args.Handled = True
        MyBase.OnManipulationDelta(args)
    End Sub


    Private Shared Sub OnPointChanged(ByVal obj As DependencyObject, ByVal args As DependencyPropertyChangedEventArgs)
        TryCast(obj, PointDragger).OnPointChanged(CType(args.OldValue, Point), CType(args.NewValue, Point))
    End Sub


    Protected Overridable Sub OnPointChanged(ByVal oldValue As Point, ByVal newValue As Point)
        ellipseGeometry.Center = newValue

        RaiseEvent PointChanged(Me, New RoutedPropertyChangedEventArgs(Of Point)(oldValue, newValue))
    End Sub
End Class
